/*
 * sensor.c
 *
 *  Created on: 12 Jun 2018
 *      Author: anderi
 */

#include "sensor.h"
#include "i2c.h"
#include "stm32f0xx_hal.h"
#include <string.h> // For Heimann memcpy routines
unsigned char reg_adr [] = {2};
unsigned char data_rec[10];

/********   Heimann global variables *********/



unsigned char data[258],data2[258];
unsigned char *p,*p2;
unsigned char giveOut,currentBuffer=0,test[2][(unsigned short)DATALength*2], currentReadBlock=0, GetBlindFrame=0, ReadBlindFrame=0;	//DataLength=1098
unsigned char SENSORREV1=1, VddSampledNow=0, VddSampledBefore=0, singleframe, firstrun, VddScalingOff, NrOfDefPix, DeadPixMask[MAXNROFDEFECTS];
unsigned short  eloffstack[ELAMOUNT][StackSize];	//ELAMOUNT=256; StackSize=10 (arbitrary, should be chosen to match the data memory of the conctroller)
unsigned short TA,Voltage[2][Pixel+PTATamount+ELAMOUNT+2],FramesBeforeEl=0;
unsigned short SetMBITCalib,SetMBITUser,SetBPACalib,SetBPAUser,SetPUCalib,SetPUUser,Resolution;
unsigned short SetBIASCalib,SetCLKCalib,SetBIASUser,SetCLKUser,DevID, DeadPixAdr[MAXNROFDEFECTS];
signed short ThGrad[Pixel], VddOff[ELAMOUNT];
signed short ThOff[Pixel];
unsigned long PixC[Pixel];
unsigned short VddStack[VddStackAmount],VddStackPointer,VddGrad[ELAMOUNT],VddRef[2],PTATThermals[2];
unsigned char VddScaling;
unsigned short GlobalGain;
char GlobalOffset;
char GetVddMeas,RefCal,pPTATStack,pVddSensorStack;
unsigned short PTATStack[STACKSIZEPTAT],VddSensorStack[STACKSIZEVDD];
volatile char FirstFrame=0, INT1occ=0;
volatile unsigned char pelStack, useStack;
volatile unsigned int VDD;
unsigned int pixsum, maskcnt, adaptedAdr;
float PTATGrad, PTATOff;

/********   END Heimann global variables *********/

//*  Global Receiver Buffer(s), For debug printf(), defined locally in Heimann code   */
//unsigned char eecpy[8] = "";


/**
 * @brief  Reads the status of the sensor
 * @retval 0x01 if status OK
 */
unsigned char SensorStatusReadOut(void)
{

	HAL_I2C_Master_Sequential_Transmit_IT(&hi2c1,SENSOR_ADR,reg_adr,1,I2C_FIRST_FRAME);
	while (HAL_I2C_GetState(&hi2c1) != HAL_I2C_STATE_READY);
	HAL_I2C_Master_Sequential_Receive_IT(&hi2c1,SENSOR_ADR,data_rec,1,I2C_LAST_FRAME);
	return data_rec[0];

}

/**
 * @brief  The write sequence is: Control_Byte (Address combined), address HIGH, address LOW, n:o of bytes in data sequence
 * @param  address Registry address in the sensor
 * @param  data Pointer to read data buffer
 * @param  numbytes number of bytes to be read
 * @retval N/A
 */

void SequentialWriteEEPROM(unsigned short address, unsigned char* data, unsigned short numbytes)
{
	//	unsigned char skriv[] = {0xFF, 0xFF, 0xFF, 0xFF};
	//	SequentialWriteEEPROM(MBIT_USER, skriv, 4);

	///@ToDo: Simple and stupid array appending without index out of bounds error catching...!

	unsigned char reg_adr[] = { ((unsigned char)((address&0xFF00)>>8)) , ((unsigned char)(address&0xFF)) };

	unsigned char write[numbytes+2];
	write[0] = reg_adr[0]; write[1] = reg_adr[1];
	short i;
	for (i = 0; i <numbytes; i++)
	{
		write[i+2] = data[i];
	}

	HAL_I2C_Master_Sequential_Transmit_IT(&hi2c1, EEPROM_ADR, write, (numbytes+2), I2C_FIRST_AND_LAST_FRAME);
	HAL_Delay(5);
	return;
}
/**
 * @brief  Ported I2C read function to be compatible with the Heimann code
 * @param  address Registry address in the sensor
 * @param  data Pointer to read data buffer
 * @param  numbytes number of bytes to be read
 * @retval N/A
 */
void HighDensSequentialRead(unsigned short address, unsigned char* data, unsigned short numbytes)
{
	unsigned char reg_data [] = {  ((unsigned char)((address&0xFF00)>>8)) , ((unsigned char)(address&0xFF)) };

	HAL_I2C_Master_Sequential_Transmit_IT(&hi2c1,EEPROM_ADR,reg_data,2,I2C_FIRST_FRAME); //write(ControlByte)
	while (HAL_I2C_GetState(&hi2c1) != HAL_I2C_STATE_READY);
	HAL_I2C_Master_Sequential_Receive_IT(&hi2c1,EEPROM_ADR,data,numbytes,I2C_FIRST_AND_LAST_FRAME );
	while (HAL_I2C_GetState(&hi2c1) != HAL_I2C_STATE_READY);

	return;
}

void IR_Sensor_Read(void)
{
	//	TAsicSFR I2Creg;
//	unsigned short PixCRaw = 0, TableNumberSensor, epsilon;
//	float common[2],PixCMax, PixCMin;
	unsigned char eecpy[8] = "";
	unsigned short gradScale;

	//	HighDensSequentialRead((unsigned short)AdrPixCMin, eecpy, 4); // Testutlasning av USER_registren, Align debug
	//	HighDensSequentialRead((unsigned short)AdrTableNumber, eecpy, 2); // Tablenumber = 0x72

//
//	HighDensSequentialRead((unsigned short)AdrPixCMin,eecpy,sizeof(float));
//	memcpy((char*)&common,eecpy,sizeof(float)*2);
//	PixCMin=(float)common[0];
//	PixCMax=(float)common[1];

	HighDensSequentialRead((unsigned short)AdrGradScale,eecpy,sizeof(char)*2);
	gradScale = ((0x00 << 8) | eecpy[0]); // 0xFF ???

//	HighDensSequentialRead((unsigned short)AdrTableNumber,eecpy,sizeof(char)*3);
//	TableNumberSensor = ((eecpy[1] << 8) | eecpy[0]);
//	//	printf("\n\r%x",TableNumberSensor);
//	epsilon=(unsigned short)eecpy[2];
//
//		HighDensSequentialRead((unsigned short)AdrMBITPixC,eecpy,sizeof(char)*5);
	//	SetMBITCalib=(unsigned short)eecpy[0];
	//	SetBIASCalib=(unsigned short)eecpy[1];
	//	SetCLKCalib=(unsigned short)eecpy[2];
	//	SetBPACalib=(unsigned short)eecpy[3];
	//	SetPUCalib=(unsigned short)eecpy[4];
	//	printf("\n\r%x",eecpy[0]);
	//	printf("\n\r%x",eecpy[1]);
	//	printf("\n\r%x",eecpy[2]);
	//	printf("\n\r%x",eecpy[3]);
	//	printf("\n\r%x",eecpy[4]);
	//
	//	/********************************************/
	//	HighDensSequentialRead((unsigned short)AdrPTATGrad,eecpy,sizeof(float)*2);
	//	memcpy((char*)&common,eecpy,sizeof(float)*2);
	//	PTATGrad=common[0];
	//	PTATOff=common[1];

	//	HighDensSequentialRead((unsigned short)AdrDevID,eecpy,sizeof(char)*2);
	//	memcpy((char*)&DevID,eecpy,sizeof(short));
	//
	//	//read all settings for clock etc. from the EEPROM, if not set, use the default values!
	//
	//	HighDensSequentialRead((unsigned short)AdrMBITUser,eecpy,sizeof(char));
	//	memcpy((unsigned char*)&SetMBITUser,eecpy,sizeof(unsigned char));
	//	if((SetMBITUser<0x09)||(SetMBITUser>0x0C)){		//EEPROM empty or setting out of spec -> set to default
	//		SetMBITUser=(unsigned char)MBITTRIMDefault;
	//		eecpy[0]=SetMBITUser;
	//		HighDensPageWrite((unsigned short)AdrMBITUser,eecpy,sizeof(char));
	//	}
	//	HighDensSequentialRead((unsigned short)AdrBIASUser,eecpy,sizeof(char));
	//	memcpy((unsigned char*)&SetBIASUser,eecpy,sizeof(unsigned char));
	//	if((!SetBIASUser)||(SetBIASUser>0x1F)){		//EEPROM empty or setting out of spec -> set to default
	//		SetBIASUser=(unsigned char)BIAScurrentDefault;
	//		eecpy[0]=SetBIASUser;
	//		HighDensPageWrite((unsigned short)AdrBIASUser,eecpy,sizeof(char));
	//	}
	//	HighDensSequentialRead((unsigned short)AdrCLKUser,eecpy,sizeof(char));
	//	memcpy((unsigned char*)&SetCLKUser,eecpy,sizeof(unsigned char));
	//	if(SetCLKUser>0x3F){		//EEPROM empty or setting out of spec -> set to default
	//		SetCLKUser=(unsigned char)CLKTRIMDefault;
	//		eecpy[0]=SetCLKUser;
	//		HighDensPageWrite((unsigned short)AdrCLKUser,eecpy,sizeof(char));
	//	}
	//	HighDensSequentialRead((unsigned short)AdrBPAUser,eecpy,sizeof(char));
	//	memcpy((unsigned char*)&SetBPAUser,eecpy,sizeof(unsigned char));
	//	if((!SetBPAUser)||(SetBPAUser>0x1F)){		//EEPROM empty or setting out of spec -> set to default
	//		SetBPAUser=(unsigned char)BPATRIMDefault;
	//		eecpy[0]=SetBPAUser;
	//		HighDensPageWrite((unsigned short)AdrBPAUser,eecpy,sizeof(char));
	//	}
	//	HighDensSequentialRead((unsigned short)AdrPUUser,eecpy,sizeof(char));
	//	memcpy((unsigned char*)&SetPUUser,eecpy,sizeof(unsigned char));
	//	if(!((SetPUUser==0x11)||(SetPUUser==0x22)||(SetPUUser==0x44)||(SetPUUser==0x88))){		//EEPROM empty or setting out of spec -> set to default
	//		SetPUUser=(unsigned char)PUTRIMDefault;
	//		eecpy[0]=SetPUUser;
	//		HighDensPageWrite((unsigned short)AdrPUUser,eecpy,sizeof(char));
	//	}
	//
	//#ifdef AdjustOffsetGain
	//	HighDensSequentialRead((unsigned short)AdrGlobalOffset,eecpy,sizeof(char));
	//	memcpy((char*)&GlobalOffset,eecpy,sizeof(char));
	//	if(GlobalOffset==(char)0xFF){
	//		GlobalOffset=0;
	//		eecpy[0]=GlobalOffset;
	//		HighDensPageWrite((unsigned short)AdrGlobalOffset,eecpy,sizeof(char));
	//	}
	//	HighDensSequentialRead((unsigned short)AdrGlobalGain,eecpy,sizeof(char)*2);
	//	memcpy((char*)&GlobalGain,eecpy,sizeof(short));
	//	//if values are not set before, do it now!
	//	if((GlobalGain==0x0000)||(GlobalGain==0xFFFF)){
	//		GlobalGain=10000;
	//		memcpy(eecpy,(char*)&GlobalGain,sizeof(short));
	//		HighDensPageWrite((unsigned short)AdrGlobalGain,eecpy,sizeof(short));
	//	}
	//#endif
	//
	//	//now load the Thermal-Grad and -Offset
	//	for(short i=0;i<(unsigned short)Pixel;i++){
	//		HighDensSequentialRead((unsigned short)AdrTh1+i*2,eecpy,sizeof(char)*2);
	//		memcpy((char*)&ThGrad[i],eecpy,sizeof(short));
	//		HighDensSequentialRead((unsigned short)AdrTh2+i*2,eecpy,sizeof(char)*2);
	//		memcpy((char*)&ThOff[i],eecpy,sizeof(short));
	//	}
	//
	//	//and finally the PixC
	//	for(short i=0;i<(unsigned short)Pixel;i++){
	//		HighDensSequentialRead((unsigned short)AdrPixC+i*2,eecpy,sizeof(char)*2);
	//		memcpy((char*)&PixCRaw,eecpy,sizeof(short));
	//#ifdef AdjustOffsetGain
	//		PixC[i]=(unsigned long)((((float)PixCRaw/65535.0)*(PixCMax-PixCMin)+(float)PixCMin)*(float)epsilon/100.0*(float)GlobalGain/10000.0+0.5);
	//#else
	//		PixC[i]=(unsigned long)((((float)PixCRaw/65535.0)*(PixCMax-PixCMin)+(float)PixCMin)*(float)epsilon/100.0+0.5);
	//#endif
	//	}
	//
	//	for(i=0;i<(unsigned short)ELAMOUNT;i++){
	//		HighDensSequentialRead((unsigned short)AdrVddCompValues2+i*2,eecpy,sizeof(char)*2);
	//		memcpy((char*)&VddGrad[i],eecpy,sizeof(short));
	//	}
	//	HighDensSequentialRead((unsigned short)AdrVddScaling,eecpy,sizeof(char));
	//	VddScaling=(unsigned short)eecpy[0];
	//	HighDensSequentialRead((unsigned short)AdrVddScalingOff,eecpy,sizeof(char));
	//	VddScalingOff=(unsigned short)eecpy[0];
	//	for(i=0;i<(unsigned short)ELAMOUNT;i++){
	//		HighDensSequentialRead((unsigned short)AdrVddCompValues+i*2,eecpy,sizeof(char)*2);
	//		memcpy((char*)&VddOff[i],eecpy,sizeof(short));
	//	}
	//	if(SENSORREV1){
	//		//readout more data from the EEPROM as more is reuired for the bug fix
	//		HighDensSequentialRead((unsigned short)AdrVddMeasTh1,eecpy,sizeof(char)*4);
	//		memcpy((char*)&VddRef,eecpy,sizeof(short)*2);
	//		HighDensSequentialRead((unsigned short)AdrPTATTh1,eecpy,sizeof(char)*4);
	//		memcpy((char*)&PTATThermals,eecpy,sizeof(short)*2);
	//	}
	//	else{
	//		HighDensSequentialRead((unsigned short)AdrVddTh1,eecpy,sizeof(char)*2);
	//		memcpy((char*)&VddRef,eecpy,sizeof(short));
	//	}
	//
	//	return;
}

void Debug_print(unsigned char* print )
{
	printf("\n\r0=%x",print[0]);
	printf("\n\r1=%x",print[1]);
	printf("\n\r2=%x",print[2]);
	printf("\n\r3=%x",print[3]);
	printf("\n\r4=%x",print[4]);
	printf("\n\r5=%x",print[5]);
	printf("\n\r6=%x",print[6]);
	printf("\n\r7=%x...\n\r",print[7]);
	return;
}

void IR_Sensor_Init(void)
{
	unsigned char buffer_init[2] = {1,1};    // Wake Up
	unsigned char buffer_trim7[2] = {9, 34}; // Enable Pull Up 10 kOhm on SDA & SCL

	/* Initialise all NEP board specifics */
	HAL_GPIO_WritePin ( EN_SENSOR_GPIO_Port, EN_SENSOR_Pin, GPIO_PIN_SET ); // Power on VDD for sensor
	HAL_Delay(20); 															// Start Up time delay

	HAL_I2C_Master_Sequential_Transmit_IT(&hi2c1,SENSOR_ADR,buffer_init,2,I2C_FIRST_AND_LAST_FRAME); //  Wake Up
	HAL_I2C_Master_Sequential_Transmit_IT(&hi2c1,SENSOR_ADR,buffer_trim7,2,I2C_FIRST_AND_LAST_FRAME); // Pull Up Enable

	printf("Sensor Init klar");
	HAL_Delay(20);
	return;

}
