#include "../../TDSH_Library/Inc/Timer.h"

#include <algorithm>

#pragma GCC diagnostic ignored "-Wsign-compare"

using namespace TimerStatus;

Timer::Timer(int id, unsigned int period = 1){
	_id = id;
	_status = BUILT;
	_period = period;
	cicli_overflow = 0;
	_internalCounter = 0;
	_status = RUNNING;
}

Timer::~Timer(){
	timers.clear();
	performers.clear();
}

void
Timer::pause(){
	switch(_status){
	case BUILT:
		break;
	case RUNNING:
		_status = SUSPENDED;
		break;
	case SUSPENDED:
		break;
	}
}

void
Timer::resume(){
	switch(_status){
	case BUILT:
		break;
	case RUNNING:
		break;
	case SUSPENDED:
		_status = RUNNING;
		break;
	}
}

void
Timer::reset(){
	switch(_status){
	case BUILT:
		break;
	case RUNNING:
		_internalCounter = 0;
		break;
	case SUSPENDED:
		_internalCounter = 0;
		break;
	}
}

void
Timer::reset(unsigned int newPeriod){
	Enum oldStatus = _status;
	pause();
	reset();
	_period = newPeriod;
	if (oldStatus == RUNNING)
		resume();
}

void
Timer::reset(unsigned int newPeriod, Enum newStatus){
	pause();
	reset();
	_period = newPeriod;
	if (newStatus == RUNNING)
		resume();
}

void Timer::tick(){
	if (_status != RUNNING)
		return;
	_internalCounter++;
	if((_internalCounter % _period)==0){
		_internalCounter = 0;
		emit_event();
	}
}

void Timer::emit_event(){

	for(int i=0;i<timers.size();i++){
			timers[i]->tick();
		}

	for(int i=0;i<performers.size();i++){
		performers[i]->setToRun();
	}

}

void Timer::add_cicli_overflow(){
	if(cicli_overflow<1000){
		cicli_overflow++;
	}else{
		//messaggio errore
		cicli_overflow=1;
	}
}

void Timer::link_Performer(Performer* p){
	//BlinkLed::blink(15,100,1);
	performers.push_back(p);
	p->setReferenceTimerId(_id);
}

void Timer::unlink_Performer(int performerID){
	Performer* toUnlink = getPerformerByID(performerID);
	toUnlink->setReferenceTimerId(-1);
	auto it = std::find(performers.begin(), performers.end(), toUnlink);
	performers.erase(it);
}


void Timer::link_Timer(Timer* vt){
	timers.push_back(vt);
	vt->_ancestorID = _id;
}

void Timer::unlink_Timer(int timerID){
	Timer* toUnlink = getTimerByID(timerID);
	toUnlink->_ancestorID = -1;
	//timers.erase(toUnlink);
	auto it = std::find(timers.begin(), timers.end(), toUnlink);
	timers.erase(it);
}

Timer*
Timer::getTimerByID(int idTimer){
	//BlinkLed::blink(14,100,1);
	for (int i = 0; i < timers.size(); i++){
		//BlinkLed::blink(14,1000,1);
		if (idTimer == timers[i]->getID())
			return timers[i];
	}
	return nullptr;
}

Performer*
Timer::getPerformerByID(int idPerformer){
	//BlinkLed::blink(14,100,1);
	for (int i = 0; i < performers.size(); i++){
		//BlinkLed::blink(14,1000,1);
		if (idPerformer == performers[i]->getId())
			return performers[i];
	}
	return nullptr;
}

std::vector<int>
Timer::getPerformersIDs(){
	std::vector<int> ret;
	for (int i = 0; i < performers.size(); i++){
		ret.push_back(performers[i]->getId());
	}
	return ret;
}

std::vector<int>
Timer::getDescendantsIDs(){
	std::vector<int> ret;
	for (int i = 0; i < timers.size(); i++){
		ret.push_back(timers[i]->_id);
	}
	return ret;
}

int
Timer::getID(){
	return _id;
}



