/* File : Performer.i */

#include "../../TDSH_Library/Inc/Performer.h"

#include <cstring>


using namespace BufferConstants;

Performer::Performer(int id, PerformerTask* task, Clock* clock){
	this->_id = id;
	this->task = task;
	this->task->setPerformerId(id);
	task->setup();

//	CircularBuffer<Data*>* asd[BufferConstants::INPUTLENGTH] {nullptr};
//	CircularBuffer<Data*>* asd2[BufferConstants::INPUTLENGTH] {nullptr};

	//memcpy(task->inputs,inputs,sizeof inputs);
//	for (int i = 0; i < BufferConstants::INPUTLENGTH; i++){
//		task->inputs[i] = inputs[i];
//	}
	_clock = clock;
	//std::fill_n(inputs, INPUTLENGTH, nullptr);
	//std::fill_n(outputs, OUTPUTLENGTH, nullptr);
}

Performer::~Performer(){
	for (int i = 0; i < OUTPUTLENGTH; i++){
		delete outputs[i];
	}

	for (int i = 0; i < ALARMSTLENGTH; i++){
			delete alarms[i];
	}
}

unsigned int
Performer::get_now(){
	return _clock->now();
}

void
Performer::setToRun(){
	_hasToRun = true;
}

bool
Performer::hasToRun(){
	return _hasToRun;
}

bool
Performer::isRunning(){
	return _running;
}

void
Performer::setReferenceTimerId(int referenceTimerId = -1) {
	_referenceTimerID = referenceTimerId;
}

int
Performer::addInputBuffer(CircularBuffer<Data*>* r){
	for(int i = 0; i < INPUTLENGTH; i++){
		if (task->inputs[i] == nullptr){
			task->inputs[i] = r;
			return 0;
		}
	}
	return -1;
}

void
Performer::removeInputBuffer(CircularBuffer<Data*>* buffer){
	for(int i = 0; i < INPUTLENGTH; i++){
		if (task->inputs[i] != nullptr && task->inputs[i] == buffer){
			task->inputs[i] = nullptr;
			return;
		}
	}
}


int
Performer::addOutputBuffer(CircularBuffer<Data*>* r){
	for(int i = 0; i < OUTPUTLENGTH; i++){
		if (outputs[i] == nullptr){
			outputs[i] = r;
			return 0;
		}
	}
	return -1;
}

void
Performer::removeOutputBuffer(CircularBuffer<Data*>* buffer){
	for(int i = 0; i < OUTPUTLENGTH; i++){
		if (outputs[i] != nullptr && outputs[i] == buffer){
			outputs[i] = nullptr;
			return;
		}
	}
}

int
Performer::addCommandBuffer(CircularBuffer<Command*>* r){
	for(int i = 0; i < COMMANDSLENGTH; i++){
		if (commands[i] == nullptr){
			commands[i] = r;
			return 0;
		}
	}
	return -1;
}

void
Performer::removeCommandBuffer(CircularBuffer<Command*>* buffer){
	for(int i = 0; i < COMMANDSLENGTH; i++){
		if (commands[i] != nullptr && commands[i] == buffer){
			commands[i] = nullptr;
			return;
		}
	}
}

int
Performer::addAlarmBuffer(CircularBuffer<Alarm*>* r){
	for(int i = 0; i < ALARMSTLENGTH; i++){
		if (alarms[i] == nullptr){
			alarms[i] = r;
			return 0;
		}
	}
	return -1;
}

void
Performer::removeAlarmBuffer(CircularBuffer<Alarm*>* buffer){
	for(int i = 0; i < ALARMSTLENGTH; i++){
		if (alarms[i] != nullptr && alarms[i] == buffer){
			alarms[i] = nullptr;
			return;
		}
	}
}

void
Performer::expose(){
	//EXPOSE DELL'OUTPUT
	exposeOutputs();
	//EXPOSE DEGLI ALLARMI

	exposeAlarms();


	//	task->_inputReadings.clear();
	//	for (int j = 0; j < INPUTLENGTH; j++){
	//		if (inputs[j] != 0){
	//			for (int i = 0; i < inputs[j]->remain(); i++){
	//				task->_inputReadings.push_back(inputs[j]->pop());
	//			}
	//		}
	//	}
}

void
Performer::exposeOutputs(){
	unsigned int size = task->_tempReadings.size();
	for (unsigned int i = 0; i < size; i++){
		for (int j = 0; j < OUTPUTLENGTH; j++){
			if (outputs[j] != 0)
				outputs[j]->push(task->_tempReadings[i]);
		}
	}
	task->_tempReadings.clear();

}

void
Performer::exposeAlarms(){
	for (int j = 0; j < ALARMSTLENGTH; j++){
		if (alarms[j] != 0){
			for (unsigned int i = 0; i < task->_alarms.size(); i++){
				alarms[j]->push(task->_alarms[i]);
			}
		}
	}
	task->_alarms.clear();
}

void
Performer::perform(){
	if (task != 0 && _hasToRun && !_running) {
		_hasToRun = false;
		_running = true;
		// Commands handling
		for (int j = 0; j < COMMANDSLENGTH; j++){
			if (commands[j] != 0){
				for (int i = 0; i < commands[j]->remain(); i++){
					task->handleCommand(commands[j]->pop());
				}
			}
		}
		task->perform(get_now());
		_running = false;
	}
	else{
		//SHOULD NOT BE HERE
	}
}
