/*
 * Engine.cpp
 *
 *  Created on: Dec 4, 2015
 *      Author: marco
 */

#include "../../TDSH_Library/Inc/Engine.h"

#include <vector>
#include <stdio.h>
#include <stdlib.h>

#pragma GCC diagnostic ignored "-Wsign-compare"

using namespace GlobalStatus;

Engine::Engine() {
	_groundTimer = new GroundTimer(this); // id 0, periodo 1
	//_timers.push_back(_groundTimer);
	_timersMap[0] = _groundTimer;
	_status = READY;
}

Engine::~Engine() {

}

Clock*
Engine::getGroundClock(){
	return _groundTimer->getGroundClock();
}

GroundTimer*
Engine::getGroundTimer(){
	return _groundTimer;
}

void
Engine::start(){
	switch(_status){
	case BUILT:
		break;
	case READY:
		_groundTimer->getGroundClock()->reset();
		_groundTimer->resume();
		_status = RUNNING;
		break;
	case RUNNING:
		break;
	case SUSPENDED:
		_groundTimer->resume();
		_status = RUNNING;
		break;
	}
}

void
Engine::pause(){
	switch(_status){
	case BUILT:
		break;
	case READY:
		break;
	case RUNNING:
		_groundTimer->pause();
		_status = SUSPENDED;
		break;
	case SUSPENDED:
		break;
	}
}

void
Engine::resume(){
	switch(_status){
	case BUILT:
		break;
	case READY:
		break;
	case RUNNING:
		break;
	case SUSPENDED:
		_groundTimer->resume();
		_status = RUNNING;
		break;
	}
}


void
Engine::start(int idTimer){
	if (_timersMap.find(idTimer) != _timersMap.end()){
		_timersMap[idTimer]->resume();
	}
}

void
Engine::pause(int idTimer){
	if (_timersMap.find(idTimer) != _timersMap.end()){
		_timersMap[idTimer]->pause();
	}
}

void
Engine::resume(int idTimer){
	if (_timersMap.find(idTimer) != _timersMap.end()){
		_timersMap[idTimer]->resume();
	}
}

void
Engine::reset(int idTimer){
	if (_timersMap.find(idTimer) != _timersMap.end()){
		_timersMap[idTimer]->reset();
	}
}

void
Engine::reset(int idTimer, int newPeriod){
	if (_timersMap.find(idTimer) != _timersMap.end()){
		_timersMap[idTimer]->reset(newPeriod);
	}
}

void
Engine::execute(){
	for (auto iterator : _performersMap){
		if (iterator.second->hasToRun()){
			if (iterator.second->isRunning()){
				//DEADLINE MISSED PER IL PERFORMER
			} else{
				iterator.second->perform();
			}
		}
	}
	epilogue();
}

void
Engine::epilogue(){
	for (auto iterator : _performersMap){//= _performersMap.begin(); iterator != _performersMap.end(); iterator++){
		if (!iterator.second->isRunning()){
			iterator.second->expose();
		}
	}
}

void
Engine::addTimerWithRef(int idTimer, int period, int idRefTimer){
	Timer* timer = new Timer(idTimer, period);
	if (_timersMap.find(idRefTimer) != _timersMap.end()){
		_timersMap[idRefTimer]->link_Timer(timer);
		_timersMap[timer->getID()] = timer;
	}
}

void
Engine::addTimer(int idTimer, int period){
	addTimerWithRef(idTimer, period, _groundTimer->getID());
}


void
Engine::addTimer(int idTimer){
	addTimer(idTimer,1);
}

void
Engine::addTimerWithRef(int idTimer, int idRefTimer){
	addTimerWithRef(idTimer, 1, idRefTimer);
}

void
Engine::addPerformer(int idTimer, int idPerformer, PerformerTask* task){
	Performer* p = new Performer(idPerformer, task, getGroundClock());
	_timersMap[idTimer]->link_Performer(p);
	_performersMap[idPerformer] = p;
}

void
Engine::removePerformer(int idPerformer){
	delete _performersMap[idPerformer];
	_performersMap.erase(idPerformer);
}

void
Engine::removeTimer(int idTimer){
	delete _timersMap[idTimer];
	_timersMap.erase(idTimer);
}


int
Engine::addPerformerInputBuffer(int idPerformer, CircularBuffer<Data*>* buffer){
	return _performersMap[idPerformer]->addInputBuffer(buffer);
}

int
Engine::addPerformerOutputBuffer(int idPerformer, CircularBuffer<Data*>* buffer){
	return _performersMap[idPerformer]->addOutputBuffer(buffer);

}

int
Engine::addPerformerCommandBuffer(int idPerformer, CircularBuffer<Command*>* buffer){
	return _performersMap[idPerformer]->addCommandBuffer(buffer);
}

int
Engine::addPerformerAlarmBuffer(int idPerformer, CircularBuffer<Alarm*>* buffer){
	return _performersMap[idPerformer]->addAlarmBuffer(buffer);
}

void
Engine::removePerformerInputBuffer(int idPerformer, CircularBuffer<Data*>* buffer){
	_performersMap[idPerformer]->removeInputBuffer(buffer);
}

void
Engine::removePerformerOutputBuffer(int idPerformer, CircularBuffer<Data*>* buffer){
	_performersMap[idPerformer]->removeOutputBuffer(buffer);
}
void
Engine::removePerformerCommandBuffer(int idPerformer, CircularBuffer<Command*>* buffer){
	_performersMap[idPerformer]->removeCommandBuffer(buffer);
}
void
Engine::removePerformerAlarmBuffer(int idPerformer, CircularBuffer<Alarm*>* buffer){
	_performersMap[idPerformer]->removeAlarmBuffer(buffer);
}

std::vector<int>
Engine::getTimersIDs(){
	std::vector<int> keys;
	for(auto timerPair: _timersMap)
		keys.push_back(timerPair.first);
	return keys;
}

std::vector<int>
Engine::getPerformersIDs(){
	std::vector<int> keys;
	for(auto PerformerPair: _performersMap)
		keys.push_back(PerformerPair.first);
	return keys;
}
