#ifndef _TIMER_H
#define _TIMER_H

#include <vector>
#include "../../TDSH_Library/Inc/Clock.h"
#include "../../TDSH_Library/Inc/Performer.h"

class Performer;

typedef void(*ptrf)();

namespace TimerStatus{
	enum Enum {BUILT, RUNNING, SUSPENDED};
}

class Timer{
public:

	std::vector<Timer*> timers;
	std::vector<Performer*> performers;

	Timer(int id, unsigned int period);
	virtual ~Timer();

	void pause();
	void resume();
	void reset();
	void reset(unsigned int newPeriod);
	void reset(unsigned int newPeriod, TimerStatus::Enum newStatus);

	void emit_event();
	void link_Performer(Performer*);
	void unlink_Performer(int performerID);
	void link_Timer(Timer*);
	void unlink_Timer(int);
	virtual void tick();

	void add_cicli_overflow();
	int getID();
	int getAncestorID() const {return _ancestorID;}
	std::vector<int> getDescendantsIDs();
	std::vector<int> getPerformersIDs();

protected:
	int _id;
	unsigned int _period, _internalCounter;
	unsigned int cicli_overflow;
	TimerStatus::Enum _status;
	int _ancestorID = -1;
	//std::vector<int> _descendantsID;
	Timer* getTimerByID(int idTimer);
	Performer* getPerformerByID(int idPerformer);
};

#endif
