//
//  PerformerTask.h
//  TAM-Android
//
//  Created by Ale on 01/11/15.
//  Copyright © 2015 ABeltramo. All rights reserved.
//

#ifndef PerformerTask_h
#define PerformerTask_h
#include <vector>

#include "../../TDSH_Library/Inc/Data/Alarm.h"
#include "../../TDSH_Library/Inc/Data/BufferConstants.h"
#include "../../TDSH_Library/Inc/Data/CircularBuffer.h"
#include "../../TDSH_Library/Inc/Data/Command.h"
#include "../../TDSH_Library/Inc/Data/Reading.h"
#include "../../TDSH_Library/Inc/Performer.h"



class PerformerTask{
public:
	std::vector<Data*> _tempReadings;

	CircularBuffer<Data*>* inputs[BufferConstants::INPUTLENGTH] {nullptr};

	std::vector<Alarm*> _alarms;

	virtual ~PerformerTask(){}
	virtual void setup(){};
	virtual void perform(unsigned int now) = 0;
	virtual void handleCommand(Command* command) = 0;

	void writeAlarm(Alarm* a) {_alarms.push_back(a);}
	void writeReading(Data* r) {
		_tempReadings.push_back(r);
	}

	int getPerformerId() const {
		return performerID;
	}

	void setPerformerId(int performerId) {
		performerID = performerId;
	}

private:
	int performerID;
};

#endif /* PerformerTask_h */
