
#ifndef Performer_h
#define Performer_h

#include <vector>
#include <algorithm>
#include <inttypes.h>
#include "../../TDSH_Library/Inc/Clock.h"
#include "../../TDSH_Library/Inc/Data/Alarm.h"
#include "../../TDSH_Library/Inc/Data/BufferConstants.h"
#include "../../TDSH_Library/Inc/Data/CircularBuffer.h"
#include "../../TDSH_Library/Inc/Data/Command.h"
#include "../../TDSH_Library/Inc/Data/Data.h"
#include "../../TDSH_Library/Inc/PerformerTask.h"



class PerformerTask;

class Performer{
public:
	Performer(int id, PerformerTask* task, Clock* clock);
	Performer(int id, PerformerTask* task) : Performer(id,task,nullptr){}
	~Performer();

	void perform();
	void expose();

	int addInputBuffer(CircularBuffer<Data*>* r);
	void removeInputBuffer(CircularBuffer<Data*>* buffer);
	int addOutputBuffer(CircularBuffer<Data*>* r);
	void removeOutputBuffer(CircularBuffer<Data*>* buffer);
	int addCommandBuffer(CircularBuffer<Command*>* r);
	void removeCommandBuffer(CircularBuffer<Command*>* buffer);
	int addAlarmBuffer(CircularBuffer<Alarm*>* r);
	void removeAlarmBuffer(CircularBuffer<Alarm*>* buffer);

	void setToRun();
	bool hasToRun();
	bool isRunning();
	void setReferenceTimerId(int referenceTimerId);

	int getId() const { return _id; }
	int getReferenceTimerId() const { return _referenceTimerID; }
	PerformerTask* getTask() const { return task; }

protected:
	unsigned int get_now();
	void exposeOutputs();
	void exposeAlarms();

private:
	int _id;
	int _referenceTimerID = -1;
	PerformerTask* task;
	bool _hasToRun = false;
	bool _running = false;
	Clock* _clock;
	//CircularBuffer<Data*>* inputs[BufferConstants::INPUTLENGTH] {nullptr};
	CircularBuffer<Data*>* outputs[BufferConstants::OUTPUTLENGTH] {nullptr};
	CircularBuffer<Command*>* commands[BufferConstants::COMMANDSLENGTH] {nullptr};
	CircularBuffer<Alarm*>* alarms[BufferConstants::ALARMSTLENGTH] {nullptr};
};

#endif /* Performer_h */
