/*
 * Engine.h
 *
 *  Created on: Dec 4, 2015
 *      Author: marco
 */

#ifndef ENGINE_H_
#define ENGINE_H_

#include <map>
#include <vector>
#include "../Inc/Clock.h"
#include "../Inc/Timer.h"
#include "../Inc/GroundTimer.h"
#include "../Inc/Performer.h"
#include "../Inc/PerformerTask.h"
#include "../Inc/Data/CircularBuffer.h"
#include "../Inc/Data/Alarm.h"
#include "../Inc/Data/Command.h"

namespace GlobalStatus{
	enum Enum {BUILT, READY, RUNNING, SUSPENDED};
}

class GroundTimer;

class Engine {
public:
	Engine();
	~Engine();

	void start();
	void pause();
	void resume();

	void start(int idTimer);
	void pause(int idTimer);
	void resume(int idTimer);
	void reset(int idTimer);
	void reset(int idTimer, int period);

	void addTimer(int idTimer);
	void addTimerWithRef(int idTimer, int idRefTimer);


	void addTimer(int idTimer, int period);
	void addTimerWithRef(int idTimer, int period, int idRefTimer);

	void addPerformer(int idTimer, int idPerformer, PerformerTask* task);

	void removeTimer(int idTimer);
	void removePerformer(int idPerformer);

	int addPerformerInputBuffer(int idPerformer, CircularBuffer<Data*>* buffer);
	void removePerformerInputBuffer(int idPerformer, CircularBuffer<Data*>* buffer);

	int addPerformerOutputBuffer(int idPerformer, CircularBuffer<Data*>* buffer);
	void removePerformerOutputBuffer(int idPerformer, CircularBuffer<Data*>* buffer);

	int addPerformerCommandBuffer(int idPerformer, CircularBuffer<Command*>* buffer);
	void removePerformerCommandBuffer(int idPerformer, CircularBuffer<Command*>* buffer);

	int addPerformerAlarmBuffer(int idPerformer, CircularBuffer<Alarm*>* buffer);
	void removePerformerAlarmBuffer(int idPerformer, CircularBuffer<Alarm*>* buffer);

	void execute();
	//void epilogue();

	Clock* getGroundClock();
	GroundTimer* getGroundTimer();
	std::vector<int> getTimersIDs();
	std::vector<int> getPerformersIDs();
private:

	GroundTimer* _groundTimer;
	std::map<int, Timer*> _timersMap;
	std::map<int, Performer*> _performersMap;
	GlobalStatus::Enum _status;
	void epilogue();
};

#endif /* ENGINE_H_ */
