/*
 * Reading.h
 *
 *  Created on: Dec 15, 2015
 *      Author: marco
 */

#ifndef TAM_READING_H_
#define TAM_READING_H_

#include "Data.h"
#include <string>
#include <sstream>


class Reading : public Data {
public:
	//Reading(int performerID) : Reading(performerID, 0){}
	Reading(int performerID, unsigned int timestamp) : Data(timestamp), _performerID(performerID){}
	~Reading(){}

	std::string toString(){
		std::string s = "{Reading:{";
		s.append("performerID: ");
		std::ostringstream oss;
		oss << _performerID;
		s.append(oss.str());
		oss.str("");
		s.append(", timeStamp: ");
		oss << getTimeStamp();
		s.append(oss.str());
		oss.str("");
		s.append("}}");
		return s;
	}

	int getPerformerID() const {
		return _performerID;
	}

private:
	int _performerID;
};

#endif /* TAM_READING_H_ */
