/********************************************************************************
  * File Name     : usart.h
  * Description   : This header file contains the usart.c defines and prototypes
  *******************************************************************************/

#ifndef __USART_H
#define __USART_H
#ifdef __cplusplus
 extern "C" {
#endif


/* ====================== Includes ====================== */
#include "stm32f0xx.h"
#include "globals.h"


/* =================== USARTx Defines =================== */
#define USART1_TX_BUF_SIZE			(uint8_t)200
#define USART1_RX_BUF_SIZE			(uint8_t)20

#define CIRC_BUF_STRUCT_DEF(x,y) uint8_t x##_space[y]; CircBufStruct x = { x##_space,y,0,0}

typedef struct __attribute__ ((__packed__))
{
	uint8_t* const buf;
	const uint8_t maxLen;
	uint8_t head;
	uint8_t tail;
}CircBufStruct;

 typedef struct __attribute__ ((__packed__))
{
	uint8_t RxDataLength;
	uint8_t RxBuf[USART1_RX_BUF_SIZE];
}Usart1RxStruct;

typedef struct __attribute__ ((__packed__))
{
	uint8_t TxDataLength;
	uint8_t TxBuf[USART1_TX_BUF_SIZE];
}Usart1TxStruct;


/* ================= USARTx Variables ================= */
Usart1RxStruct sUsart1Rx;
Usart1TxStruct sUsart1Tx;


/* ====================== Prototypes ====================== */
void usart_Config(void);
void usart_ClrBuf(uint8_t *pBuf, uint8_t length);
uint8_t usart_PushTxCircBuf(uint8_t byte);
uint8_t usart_PopTxCircBuf(uint8_t *byte);
uint8_t usart_AddCrLf(uint8_t numCrLf);
uint8_t usart_hexByteToStrAdd(uint8_t hexByte);
uint8_t usart_hexByteToDecStrAdd(uint8_t hexByte);
uint8_t usart_hexWordToDecStrAdd(uint16_t hexWord);
uint8_t usart_strAdd(char *txStr);
void usart_TxData(void);



#ifdef __cplusplus
}
#endif

#endif
