/********************************************************************************
  * File Name     : timer.h
  * Description   : This header file contains the timer.c defines and prototypes
  *******************************************************************************/

#ifndef __TIMER_H
#define __TIMER_H
#ifdef __cplusplus
 extern "C" {
#endif


/* ====================== Includes ====================== */
#include "stm32f0xx.h"
#include "globals.h"


/* ======================= Defines ======================= */
typedef struct
{
	uint16_t Time_uSec;
	uint16_t Time_mSec;
	uint8_t Time_Sec;
	uint8_t Time_Min;
	uint8_t Time_Hr;
} TimeTypeStruct;


/* ======================= Externs ======================= */
extern uint32_t SysTickDlyCnt;
extern uint16_t LidSwChkTimeCnt;

/* ===============================  Macros =============================== */


/* ====================== Prototypes ====================== */
void time_SysTickConfig(void);
void time_SysTickDec(void);
void time_SysTickDelay(uint32_t delay);
void tim3_TimerConfig(void);
void tim3_RtcUpdate(void);


#ifdef __cplusplus
}
#endif

#endif
