/********************************************************************************
  * File Name     : globals.h
  * Description   : This header file contains the global defines and prototypes
  *******************************************************************************/

#ifndef __GLOBALS_H
#define __GLOBALS_H
#ifdef __cplusplus
 extern "C" {
#endif


/* ====================== Includes ====================== */
#include "stm32f0xx.h"


/* ======================= Defines ======================= */
#define OFF									(uint8_t)0
#define ON									(uint8_t)1

#define RESET								(uint8_t)0
#define SET									(uint8_t)1

#define ERR									(uint8_t)0
#define OK									(uint8_t)1

typedef struct __attribute__ ((__packed__))
{
	uint16_t StartSwFlag				: 1;
	uint16_t LidSwFlag					: 1;
} SysFlagsStruct;

SysFlagsStruct sSysFlags;



#ifdef __cplusplus
}
#endif

#endif
