/********************************************************************************
  * File Name          : stm32f0xx_it.c
  * Description        : This source file contains the interrupt handlers
  *******************************************************************************/

/* ============================= Includes ============================= */
#include "stm32f0xx_it.h"
#include "timer.h"
#include "gpio.h"


/* ========================== External Variables ========================== */


/* =========================== Private Defines =========================== */


/* ========================== Private Variables ========================== */


/* ===================== Private Function Prototypes ====================== */


void NMI_Handler(void)
{
}

void HardFault_Handler(void)
{
  while(1);
}

void SVC_Handler(void)
{
}

void PendSV_Handler(void)
{
}

void SysTick_Handler(void)
{
  if (SysTickDlyCnt != 0x00)
  {
  	SysTickDlyCnt--;
  }
}

void PPP_IRQHandler(void)
{
}

void TIM3_IRQHandler(void)
{
  if (TIM_GetITStatus(TIM3, TIM_IT_Update) != RESET)
  {
    TIM_ClearITPendingBit(TIM3, TIM_IT_Update);
    tim3_RtcUpdate();
  }
}


/**
  * @}
  */

/**
  * @}
  */
