/********************************************************************************
  * File Name     : gpio.h
  * Description   : This header file contains the gpio.c defines and prototypes
  *******************************************************************************/

#ifndef __GPIO_H
#define __GPIO_H
#ifdef __cplusplus
 extern "C" {
#endif


/* ====================== Includes ====================== */
#include "stm32f0xx.h"
#include "globals.h"


/* ======================= Defines ======================= */
#define SWs_PORT						GPIOA
 /* ________Circor test pin _______________________________ */
#define TEST_PIN_SW						GPIO_Pin_5

#define START_SW						GPIO_Pin_6
#define H2O_SW							GPIO_Pin_7
#define LID_SW							GPIO_Pin_8

#define WASH_LED_PORT						GPIOA
#define WASH_LED						    GPIO_Pin_11
#define SPIN_LED_PORT						GPIOA
#define SPIN_LED						    GPIO_Pin_12
#define MOT_CTRL_PORT						GPIOB
#define RELAY_CTRL						    GPIO_Pin_1
#define MOT_FWD_CTRL						GPIO_Pin_6
#define MOT_REV_CTRL						GPIO_Pin_7
#define H2O_CTRL_PORT						GPIOB
#define H2O_COLD_CTRL						GPIO_Pin_4
#define L_MAST_CTRL						    GPIO_Pin_5


#define MOT_OFF							0
#define MOT_FWD							1
#define MOT_REV							2
#define H2O_OFF							3
#define H2O_ON							4
#define H2O_COLD						5

#define LID_OPEN						SET
#define LID_CLS							RESET

#define WHILE_LOOP_200ms_DLY					(uint32_t)2000000
#define WHILE_LOOP_500ms_DLY					(uint32_t)5000000

#define LID_SW_CHK_PERIOD					(uint32_t)300

#define H2O_OFF_DLY_MOT_FWD     			(uint16_t)4
#define MOT_FWD_ON_TIME_1       			(uint16_t)720

#define MOT_REV_DLY_ON_TIME_1   			(uint16_t)4
#define MOT_REV_ON_TIME_1       			(uint16_t)300
#define MOT_REV_H2O_DLY_ON_TIME_1     			(uint16_t)90
#define H2O_ON_TIME_1           			(uint16_t)30

#define MOT_REV_DLY_ON_TIME_2   			(uint16_t)4
#define MOT_REV_ON_TIME_2       			(uint16_t)300
#define MOT_REV_H2O_DLY_ON_TIME_2     (uint16_t)4
#define H2O_ON_TIME_2           			(uint16_t)30

#define LED_OFF												(uint16_t)RESET
#define LED_ON												(uint16_t)SET

typedef struct __attribute__ ((__packed__))
{
	uint8_t MotState;
	uint8_t H2OState;
} SysStatusStruct;

typedef struct __attribute__ ((__packed__))
{
	uint16_t H2ODlyOn;
	uint16_t H2OOnTime;
	uint16_t MotDlyOn;
	uint16_t MotOnTime;
} MotH2OCtrlStruct;

typedef struct __attribute__ ((__packed__))
{
uint8_t LedState;
uint16_t LedFlashRate;
} LedCtrlStruct;

SysStatusStruct 	sSysStatus;
MotH2OCtrlStruct	sMotH2OCtrl;
LedCtrlStruct 		sWashLed;
LedCtrlStruct 		sSpinLed;


/* ======================= Externs ======================= */
extern uint16_t PwrOnDlyCnt;
extern uint16_t MotFwdOnCnt;
extern uint16_t MotFwdDlyOnCnt;
extern uint16_t MotRevOnCnt;
extern uint16_t MotRevDlyOnCnt;
extern uint16_t H2OOnCnt;
extern uint16_t H2ODlyOnCnt;
extern uint16_t H2OOnTimeoutCnt;


/* ====================== Prototypes ====================== */
void gpio_ConfigAll(void);
void gpio_H2OCtrl(uint8_t waterState);
void gpio_StartSwWait(void);
uint8_t gpio_H2OPressSwTrigWait(void);
void gpio_LidSwChk(void);
void gpio_LidSwTrig(void);
void gpio_ToggleBit(GPIO_TypeDef* GPIOx, uint16_t GPIO_Pin);
void gpio_LedsCtrl(void);
void gpio_MotH2OCtrl(void);
void gpio_SysCtrlSeq(void);


#ifdef __cplusplus
}
#endif

#endif
