/*
 * I2C.c
 *
 *  Created on: Mar 8, 2017
 *      Author: REYN
 */

#include <stdint.h>
#include "I2C.h"

void i2cTX(uint8_t devADDR, uint8_t devREG, uint8_t dataTX, uint8_t sizeOfDataTX)
{
	uint8_t TX[sizeOfDataTX];

	TX[0] = devREG;
	TX[1] = dataTX;

	HAL_I2C_Master_Transmit(&hi2c1, devADDR << 1, TX, sizeOfDataTX, I2CTIMEOUT);
}

uint16_t i2cRX(uint8_t devADDR, uint8_t devREG, uint8_t sizeOfDataRX)
{
	uint8_t RX[sizeOfDataRX];

	// Tell device that the master is wanting to receive data from a specific register
	HAL_I2C_Master_Transmit(&hi2c1, devADDR << 1, &devREG, 1, I2CTIMEOUT);

	if (sizeOfDataRX < 2)
	{
		HAL_I2C_Master_Receive (&hi2c1, devADDR << 1, &RX[0], sizeOfDataRX, I2CTIMEOUT);
	}
	else
	{
		HAL_I2C_Master_Receive (&hi2c1, devADDR << 1, RX, sizeOfDataRX, I2CTIMEOUT);
	}

	return *RX;
}
