/**
*****************************************************************************
**
**  File        : syscalls.c
**
**  Abstract    : System Workbench Minimal System calls file
**
**				This is a hack to implement ENABLE_MULTIPATH_STDOUT
**				for Cortex-M micro-controller.
**				The code base was merged from AC6 and Liviu Ionescu.
**				by -Andy Blue , bluenow1896@gmail.com, 01/17/2017
**
** 		          For more information about which c-functions
**                need which of these lowlevel functions
**                please consult the Newlib libc-manual
**
**  Environment : System Workbench for MCU
**
**  Distribution: The file is dis tributed �as is,� without any warranty
**                of any kind.
**
**  (c)Copyright System Workbench for MCU.
**  You may use this file as-is or modify it according to the needs of your
**  project. Distribution of this file (unmodified or modified) is not
**  permitted. System Workbench for MCU permit registered System Workbench(R) users the
**  rights to distribute the assembled, compiled & linked contents of this
**  file as part of an application binary file, provided that it is built
**  using the System Workbench for MCU toolchain.
**
*****************************************************************************
*/
#define	ENABLE_MULTIPATH_STDOUT

#define	TRACE
#define ENABLE_USE_TRC_SEMIHOSTING_STDOUT
#define ENABLE_USE_SYS_UARTX_STDOUT

/* Includes */
#include <sys/stat.h>
#include <stdlib.h>
#include <errno.h>
#include <stdio.h>
#include <signal.h>
#include <time.h>
#include <sys/time.h>
#include <sys/times.h>


/* Variables */
//#undef errno
extern int errno;
#define FreeRTOS
#define MAX_STACK_SIZE 0x2000

//extern int __io_putchar(int ch) __attribute__((weak));
extern int __io_getchar(void) __attribute__((weak));

#ifndef FreeRTOS
  register char * stack_ptr asm("sp");
#endif


register char * stack_ptr asm("sp");

char *__env[1] = { 0 };
char **environ = __env;


/* Functions */
void initialise_monitor_handles()
{
}

int _getpid(void)
{
	return 1;
}

int _kill(int pid, int sig)
{
	errno = EINVAL;
	return -1;
}

void _exit (int status)
{
	_kill(status, -1);
	while (1) {}		/* Make sure we hang here */
}

int _read (int file, char *ptr, int len)
{
	int DataIdx;

	for (DataIdx = 0; DataIdx < len; DataIdx++)
	{
		*ptr++ = __io_getchar();
	}

return len;
}

#if defined(ENABLE_USE_TRC_SEMIHOSTING_STDOUT)
static ssize_t
_trace_write_semihosting_stdout(const char* buf, size_t nbyte);
#endif

#if	defined(ENABLE_USE_SYS_UARTX_STDOUT)
static ssize_t
_trace_write_uart_stdout (const char* buf, size_t nbyte);
#endif

#if	defined(ENABLE_MULTIPATH_STDOUT)

typedef enum path_to_stdout_type
{
	NULL_TO_STDOUT,
	SEMIHOSTING_TO_STDOUT,
	UART1_TO_STDOUT,
	UART2_TO_STDOUT,
	UART3_TO_STDOUT,
	UART4_TO_STDOUT,
	UART5_TO_STDOUT,
	UARTMAX_TO_STDOUT
} PATH_TO_STDOUT_T;

PATH_TO_STDOUT_T	path_to_stdout = NULL_TO_STDOUT;
#endif

int _write(int file, char *ptr, int len)
{

#if	defined(ENABLE_MULTIPATH_STDOUT)
	if(path_to_stdout == NULL_TO_STDOUT)
	{
		;// drop and do nothing
	}else if(path_to_stdout == SEMIHOSTING_TO_STDOUT)
	{
	  #if defined(ENABLE_USE_TRC_SEMIHOSTING_STDOUT)
		len = _trace_write_semihosting_stdout (ptr, len);
	  #endif
	}
	else if((path_to_stdout >= UART1_TO_STDOUT) && (path_to_stdout < UARTMAX_TO_STDOUT))
	{
	  #if	defined(ENABLE_USE_SYS_UARTX_STDOUT)
		len = _trace_write_uart_stdout (ptr, len);
	  #endif
	}
#endif
	return len;
}

caddr_t _sbrk(int incr)
{
	extern char end asm("end");
	static char *heap_end;
	char *prev_heap_end;

	if (heap_end == 0)
		heap_end = &end;

	prev_heap_end = heap_end;
	if (heap_end + incr > stack_ptr)
	{
//		write(1, "Heap and stack collision\n", 25);
//		abort();
		errno = ENOMEM;
		return (caddr_t) -1;
	}

	heap_end += incr;

	return (caddr_t) prev_heap_end;
}

int _close(int file)
{
	return -1;
}


int _fstat(int file, struct stat *st)
{
	st->st_mode = S_IFCHR;
	return 0;
}

int _isatty(int file)
{
	return 1;
}

int _lseek(int file, int ptr, int dir)
{
	return 0;
}

int _open(char *path, int flags, ...)
{
	/* Pretend like we always fail */
	return -1;
}

int _wait(int *status)
{
	errno = ECHILD;
	return -1;
}

int _unlink(char *name)
{
	errno = ENOENT;
	return -1;
}

int _times(struct tms *buf)
{
	return -1;
}

int _stat(char *file, struct stat *st)
{
	st->st_mode = S_IFCHR;
	return 0;
}

int _link(char *old, char *new)
{
	errno = EMLINK;
	return -1;
}

int _fork(void)
{
	errno = EAGAIN;
	return -1;
}

int _execve(char *name, char **argv, char **env)
{
	errno = ENOMEM;
	return -1;
}


//
// This file is part of the µOS++ III distribution.
// Copyright (c) 2014 Liviu Ionescu.
//
#define	TRACE
// ----------------------------------------------------------------------------

#if defined(TRACE)

#include "Trace.h"

// ----------------------------------------------------------------------------

// One of these definitions must be passed via the compiler command line
// Note: small Cortex-M0/M0+ might implement a simplified debug interface.
//#define __ARM_ARCH_7M__
//#define ENABLE_USE_TRC_ITM_STDOUT
//#define OS_USE_TRACE_SEMIHOSTING_DEBUG
//#define ENABLE_USE_TRC_SEMIHOSTING_STDOUT

#if !(defined(__ARM_ARCH_7M__) || defined(__ARM_ARCH_7EM__))
#if defined(ENABLE_USE_TRC_ITM_STDOUT)
#undef ENABLE_USE_TRC_ITM_STDOUT
#warning "ITM unavailable"
#endif // defined(ENABLE_USE_TRC_ITM_STDOUT)
#endif // !(defined(__ARM_ARCH_7M__) || defined(__ARM_ARCH_7EM__))

// ----------------------------------------------------------------------------

// Forward definitions.

#if defined(ENABLE_USE_TRC_ITM_STDOUT)
static ssize_t
_trace_write_itm (const char* buf, size_t nbyte);
#endif

#if defined(ENABLE_USE_TRC_SEMIHOSTING_STDOUT)
static ssize_t
_trace_write_semihosting_stdout(const char* buf, size_t nbyte);
#endif

#if defined(OS_USE_TRACE_SEMIHOSTING_DEBUG)
static ssize_t
_trace_write_semihosting_debug(const char* buf, size_t nbyte);
#endif

// ----------------------------------------------------------------------------

void
trace_initialize(void)
{
  // No initialisations required for ITM / semihosting
}

// ----------------------------------------------------------------------------

// This function is called from _write() for fd==1 or fd==2 and from some
// of the trace_* functions.

ssize_t
trace_write (const char* buf __attribute__((unused)),
	     size_t nbyte __attribute__((unused)))
{
#if defined(ENABLE_USE_TRC_ITM_STDOUT)
  return _trace_write_itm (buf, nbyte);
#elif defined(ENABLE_USE_TRC_SEMIHOSTING_STDOUT)
  return _trace_write_semihosting_stdout(buf, nbyte);
#elif defined(OS_USE_TRACE_SEMIHOSTING_DEBUG)
  return _trace_write_semihosting_debug(buf, nbyte);
#endif

  return -1;
}

// ----------------------------------------------------------------------------

#if defined(ENABLE_USE_TRC_ITM_STDOUT)

#if defined(__ARM_ARCH_7M__) || defined(__ARM_ARCH_7EM__)

// ITM is the ARM standard mechanism, running over SWD/SWO on Cortex-M3/M4
// devices, and is the recommended setting, if available.
//
// The JLink probe and the GDB server fully support SWD/SWO
// and the JLink Debugging plug-in enables it by default.
// The current OpenOCD does not include support to parse the SWO stream,
// so this configuration will not work on OpenOCD (will not crash, but
// nothing will be displayed in the output console).

#if !defined(OS_INTEGER_TRACE_ITM_STIMULUS_PORT)
#define OS_INTEGER_TRACE_ITM_STIMULUS_PORT     (0)
#endif

static ssize_t
_trace_write_itm (const char* buf, size_t nbyte)
{
  for (size_t i = 0; i < nbyte; i++)
    {
      // Check if ITM or the stimulus port are not enabled
      if (((ITM->TCR & ITM_TCR_ITMENA_Msk) == 0)
	  || ((ITM->TER & (1UL << OS_INTEGER_TRACE_ITM_STIMULUS_PORT)) == 0))
	{
	  return (ssize_t)i; // return the number of sent characters (may be 0)
	}

      // Wait until STIMx is ready...
      while (ITM->PORT[OS_INTEGER_TRACE_ITM_STIMULUS_PORT].u32 == 0)
	;
      // then send data, one byte at a time
      ITM->PORT[OS_INTEGER_TRACE_ITM_STIMULUS_PORT].u8 = (uint8_t) (*buf++);
    }

  return (ssize_t)nbyte; // all characters successfully sent
}

#endif // defined(__ARM_ARCH_7M__) || defined(__ARM_ARCH_7EM__)

#endif // ENABLE_USE_TRC_ITM_STDOUT

// ----------------------------------------------------------------------------

#if defined(OS_USE_TRACE_SEMIHOSTING_DEBUG) || defined(ENABLE_USE_TRC_SEMIHOSTING_STDOUT)

#include "semihosting.h"

// Semihosting is the other output channel that can be used for the trace
// messages. It comes in two flavours: STDOUT and DEBUG. The STDOUT channel
// is the equivalent of the stdout in POSIX and in most cases it is forwarded
// to the GDB server stdout stream. The debug channel is a separate
// channel. STDOUT is buffered, so nothing is displayed until a \n;
// DEBUG is not buffered, but can be slow.
//
// Choosing between semihosting stdout and debug depends on the capabilities
// of your GDB server, and also on specific needs. It is recommended to test
// DEBUG first, and if too slow, try STDOUT.
//
// The JLink GDB server fully support semihosting, and both configurations
// are available; to activate it, use "monitor semihosting enable" or check
// the corresponding button in the JLink Debugging plug-in.
// In OpenOCD, support for semihosting can be enabled using
// "monitor arm semihosting enable".
//
// Note: Applications built with semihosting output active cannot be
// executed without the debugger connected and active, since they use
// BKPT to communicate with the host. Attempts to run them standalone or
// without semihosting enabled will usually be terminated with hardware faults.

#endif // OS_USE_TRACE_SEMIHOSTING_DEBUG_*

// ----------------------------------------------------------------------------

#if defined(ENABLE_USE_TRC_SEMIHOSTING_STDOUT)

static ssize_t
_trace_write_semihosting_stdout (const char* buf, size_t nbyte)
{
#if 0 && (defined(__ARM_ARCH_7M__) || defined(__ARM_ARCH_7EM__)) && !defined(OS_HAS_NO_CORE_DEBUG)
  // Check if the debugger is enabled. CoreDebug is available only on CM3/CM4.
  // [Contributed by SourceForge user diabolo38]
  if ((CoreDebug->DHCSR & CoreDebug_DHCSR_C_DEBUGEN_Msk) == 0)
    {
      // If not, pretend we wrote all bytes
      return (ssize_t) (nbyte);
    }
#endif // defined(__ARM_ARCH_7M__) || defined(__ARM_ARCH_7EM__)

  static int handle;
  void* block[3];
  int ret;

  if (handle == 0)
    {
      // On the first call get the file handle from the host
      block[0] = ":tt"; // special filename to be used for stdin/out/err
      block[1] = (void*) 4; // mode "w"
      // length of ":tt", except null terminator
      block[2] = (void*) (sizeof(":tt") - 1);

      ret = call_host (SEMIHOSTING_SYS_OPEN, (void*) block);
      if (ret == -1)
        return -1;

      handle = ret;
    }

  block[0] = (void*) handle;
  block[1] = (void*) buf;
  block[2] = (void*) nbyte;
  // send character array to host file/device
  ret = call_host (SEMIHOSTING_SYS_WRITE, (void*) block);
  // this call returns the number of bytes NOT written (0 if all ok)

  // -1 is not a legal value, but SEGGER seems to return it
  if (ret == -1)
    return -1;

  // The compliant way of returning errors
  if (ret == (int) nbyte)
    return -1;

  // Return the number of bytes written
  return (ssize_t) (nbyte) - (ssize_t) ret;
}

#endif // ENABLE_USE_TRC_SEMIHOSTING_STDOUT

// ----------------------------------------------------------------------------

#if defined(OS_USE_TRACE_SEMIHOSTING_DEBUG)

#define OS_INTEGER_TRACE_TMP_ARRAY_SIZE  (16)

static ssize_t
_trace_write_semihosting_debug (const char* buf, size_t nbyte)
{
#if (defined(__ARM_ARCH_7M__) || defined(__ARM_ARCH_7EM__)) && !defined(OS_HAS_NO_CORE_DEBUG)
  // Check if the debugger is enabled. CoreDebug is available only on CM3/CM4.
  // [Contributed by SourceForge user diabolo38]
  if ((CoreDebug->DHCSR & CoreDebug_DHCSR_C_DEBUGEN_Msk) == 0)
    {
      // If not, pretend we wrote all bytes
      return (ssize_t) (nbyte);
    }
#endif // defined(__ARM_ARCH_7M__) || defined(__ARM_ARCH_7EM__)

  // Since the single character debug channel is quite slow, try to
  // optimise and send a null terminated string, if possible.
  if (buf[nbyte] == '\0')
    {
      // send string
      call_host (SEMIHOSTING_SYS_WRITE0, (void*) buf);
    }
  else
    {
      // If not, use a local buffer to speed things up
      char tmp[OS_INTEGER_TRACE_TMP_ARRAY_SIZE];
      size_t togo = nbyte;
      while (togo > 0)
        {
          unsigned int n = ((togo < sizeof(tmp)) ? togo : sizeof(tmp));
          unsigned int i = 0;
          for (; i < n; ++i, ++buf)
            {
              tmp[i] = *buf;
            }
          tmp[i] = '\0';

          call_host (SEMIHOSTING_SYS_WRITE0, (void*) tmp);

          togo -= n;
        }
    }

  // All bytes written
  return (ssize_t) nbyte;
}

#endif // OS_USE_TRACE_SEMIHOSTING_DEBUG

#endif // TRACE

#if	defined(ENABLE_USE_SYS_UARTX_STDOUT)

#include       "usart.h"

UART_HandleTypeDef 	* pUartHandle = NULL ;//&huart2;

ssize_t
_trace_write_uart_stdout (const char* buf, size_t len)
{
	int DataIdx;

	for (DataIdx = 0; DataIdx < len; DataIdx++)
	{
		HAL_UART_Transmit(pUartHandle, (uint8_t *)buf++, 1, 0xFFFF);
	}

	return len;

}
#endif	//ENABLE_USE_SYS_UARTX_STDOUT

#include	<string.h>
FILE * freopen (const char *filename, const char *opentype, FILE *stream)
{
       if (stream == stdout)
       {
           if(!strcmp(filename, "/dev/null"))
           {
                   path_to_stdout = NULL_TO_STDOUT;
           }
           else if(!strcmp(filename, "/dev/semihosting"))
		   {
				   path_to_stdout = SEMIHOSTING_TO_STDOUT;
		   }
		   else if (!strcmp(filename, "/dev/ttyS2"))
		   {
				   path_to_stdout = UART2_TO_STDOUT;
				   pUartHandle = &huart2;
		   }
		   else if (!strcmp(filename, "/dev/ttyS3"))
		   {
				   path_to_stdout = UART3_TO_STDOUT;
				   pUartHandle = &huart3;
		   }
       }
       return stream;
}

// ----------------------------------------------------------------------------
