#include "mbed.h"                                       
#include "SPI_TFT_ILI9341.h"                            
#include "Arial28x28.h" 
//#include "Arial_9.h"  
#include "font_big.h"



                               
SPI_TFT_ILI9341 TFT(D11, D12, D13, D8, D9, D10,"TFT");  // (mosi, miso, sck, cs, reset, dc)
#define READBUFFERSIZE (32)

Serial g_serial(D5,D4);


int ReadLineString( Serial& serial,
                    char szReadBuffer[], const int ciReadBufferSize, int& riIndexChar,
                    char szLineString[], const int ciLineStringSize )
{
    while( 1 )
    {
        if( !serial.readable() )
        {
            break;
        }
        char c = serial.getc();
        if( '\r' == c  )
        {
            szReadBuffer[riIndexChar] = '\0';
            strncpy( szLineString, szReadBuffer, ciLineStringSize - 1 );
            szLineString[ciLineStringSize - 1] = '\0';
            riIndexChar = 0;
            return (1);
        }
        else if( '\n' == c )
        {
            ;
        }
        else
        {
            if( (ciReadBufferSize - 1) > riIndexChar )
            {
                szReadBuffer[riIndexChar] = c;
                riIndexChar++;
            }
        }
    }
    return(0);
}



int main()
{
    TFT.set_orientation(2);                             
    TFT.background(0x00ff);                               
    TFT.foreground(0xFFFF);                             
    TFT.cls();                                          
    TFT.set_font((unsigned char*) Neu42x35);          
    TFT.locate(90, 100);                                
    TFT.printf("Go");   
    TFT.locate(59, 135);                                
    TFT.printf("Team");  
    TFT.locate(12, 170);                                
    TFT.printf("Awesome");  
    g_serial.baud(9600);
    
 


while (1)
{    
    //int iCounter = 0;
    char szReadBuffer[READBUFFERSIZE] = "";
    int iIndexChar = 0;
    while(1)
    {
      //iCounter++;
        // read
        char szLineString[READBUFFERSIZE];
        if( !ReadLineString( g_serial, 
                             szReadBuffer, READBUFFERSIZE, iIndexChar,
                             szLineString, READBUFFERSIZE ) )
        {
            continue;
        }


    TFT.locate(55,205);
    TFT.printf(szLineString);
    TFT.printf("            ");
    }
}
}