/* #####################################################################
                             SerialComms.cpp
                             ---------------
                
                          Surface Ship, Group 5
                          ---------------------
 
 Written by:        Steven Kay
 
 Date:              February 2016
 
 Function:          This 
 
 Version:           1.0
 
 Version History
 ---------------
 
 1.1                rgdfgdfgdfggdfgdg
 
 1.0                gdgddfdddgd
    
 ##################################################################### */

#include "mbed.h"
#include "SerialComms.h"

SerialComms::SerialComms(PinName tx,PinName rx)
{
    _HLC_Conn = new RawSerial(tx,rx);
    _HLC_Conn-> baud(SERIAL_BAUD_RATE);
    _HLC_Conn -> format(8,SerialBase::None,1);
    
    _HLC_Conn -> attach(this,&SerialComms::incomingDataISR,RawSerial::RxIrq);
    
    incomingDataUpdate = FALSE;
}

void SerialComms::incomingDataISR()
{
    receiverBuffer = _HLC_Conn -> getc();
    incomingDataUpdate = TRUE;
}

uint8_t SerialComms::getCommData()
{
    if(incomingDataUpdate == TRUE)
    {
        if( ((receiverBuffer&0x0F)==MOTORS_FORWARD ||
            (receiverBuffer&0x0F)==MOTORS_BACKWARD ||
            (receiverBuffer&0x0F)==MOTORS_LEFT ||
            (receiverBuffer&0x0F)==MOTORS_RIGHT ||
            (receiverBuffer&0x0F)==MOTORS_ARM ||
            (receiverBuffer&0x0F)==MOTORS_OFF ||
            (receiverBuffer>>4)&(0x0F)==MAGNET_ON ||
            (receiverBuffer>>4)&(0x0F)==MAGNET_OFF
            /* AND BALLAST REQUIREMENTS */              ) )
        {
            incomingDataUpdate = FALSE;
            return receiverBuffer;
        }
        else
        {
            incomingDataUpdate = FALSE;
            return 0xFF;
        } 
    }  
    else
    {
        incomingDataUpdate = FALSE;
        return 0xFF;
    }       
}
