/*
 * @file stm32xx_hal_pub_.c
 *
 *  Created on: Dec 16, 2015
 *      Author:
 */

#if defined(STM32F373xC) || defined(STM32F378xx)

#include "TEC_Includes.h"
//#include "stm32f373xc.h"

/** @defgroup TEC_Private_Functions_Made_Public Private Functions made Public
 *  These functions are copied from HAL because they are needed by this application, and
 *  they were made unaccessable by
 * @{
 */

/** @defgroup SDADC_Publicized_Functions SDADC Functions
  *  These functions are copied from stm32f3xx_hal_sdadc.c
  * @{
  */

#define SDADC_TIMEOUT          200
#define SDADC_CONFREG_OFFSET   0x00000020
#define SDADC_JDATAR_CH_OFFSET 24
#define SDADC_MSB_MASK         0xFFFF0000
#define SDADC_LSB_MASK         0x0000FFFF

/**
  * @brief  This function allows to enter in init mode for SDADC instance.
  * @param  hsdadc: SDADC handle.
  * @retval HAL status.
  */
HAL_StatusTypeDef SDADC_EnterInitMode_pub(SDADC_HandleTypeDef* hsdadc)
{
  uint32_t tickstart = 0;

  /* Set INIT bit on SDADC_CR1 register */
  hsdadc->Instance->CR1 |= SDADC_CR1_INIT;

  /* Wait INITRDY bit on SDADC_ISR */
  tickstart = HAL_GetTick();
  while((hsdadc->Instance->ISR & SDADC_ISR_INITRDY) == (uint32_t)RESET)
  {
    if((HAL_GetTick()-tickstart) > SDADC_TIMEOUT)
    {
      return HAL_TIMEOUT;
    }
  }

  /* Return HAL status */
  return HAL_OK;
}

/**
  * @brief  This function allows to exit from init mode for SDADC instance.
  * @param  hsdadc: SDADC handle.
  * @retval None.
  */
void SDADC_ExitInitMode_pub(SDADC_HandleTypeDef* hsdadc)
{
  /* Reset INIT bit in SDADC_CR1 register */
  hsdadc->Instance->CR1 &= ~(SDADC_CR1_INIT);
}

/**
 * @}
 */

/**
 * @}
 */

#endif /* defined(STM32F373xC) || defined(STM32F378xx) */
